/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareAnalysis;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0DRule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0DRuleBase;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0DXMLParser;
import com.ibm.hwmca.base.pa.event.HardwareDataEventClass0D;
import com.ibm.hwmca.base.pa.event.HardwareFailuresClass04;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;

public class HardwareAnalysisClass0D
extends HardwareAnalysis
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAH0DAT";
    private static final String TRACE_MASKF = "XPAH0DAF";
    private static final String TRACE_MASKD = "XPAH0DAD";
    private Calendar currentCalendar = Calendar.getInstance(UserContext.getCurrentUserContext().getTimeZone(), UserContext.getCurrentUserContext().getLocale());
    private HardwareDataEventClass0D ourEvent = null;

    public HardwareAnalysisClass0D() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        super.analyze(event);
        HardwareDataEventClass0D ourEvent = (HardwareDataEventClass0D)event;
        String text = new String();
        switch (this.getEventType()) {
            case 12: {
                Trace.trace(TRACE_MASKD, ": Investigate type 0C for LAN or SDLC");
                Trace.trace(TRACE_MASKD, ": pccaddr3=" + ourEvent.getPccadd3());
                if (ourEvent.getPccadd3().indexOf("LAN") != -1) {
                    text = "LANN";
                    break;
                }
                if (ourEvent.getPccadd3().indexOf("SDLC") != -1) {
                    text = "SDLC";
                    break;
                }
                Trace.trace(TRACE_MASKD, ": Invalid ROF log");
                new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), HardwareFailuresClass04.XP33_0D_BAD_ROF_LOG).log();
                Trace.trace(TRACE_MASKT, "<-- analyze()");
                return;
            }
            default: {
                text = null;
            }
        }
        String baseFilePath = HardwareAnalysisClass0D.getBaseFilePath("paconfig");
        String XMLFileToUse = baseFilePath + "iqyp330d.xml";
        HardwareEvent0DRuleBase rb = null;
        try {
            rb = HardwareEvent0DXMLParser.parseXML(XMLFileToUse);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
        }
        if (rb == null) {
            Trace.trace(TRACE_MASKD, ": ADEPT did not return rules base");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), HardwareFailuresClass04.XP33_0D_ADEPT_CALL_ERR).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        HardwareEvent0DRule rule = rb.findRule(this.getEventType(), text);
        if (rule == null) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL refcode.");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), HardwareFailuresClass04.XP33_0D_ADEPT_DATA_ERR).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        if (rule.getRefCode().equals("UNKNOWN_REFCODE")) {
            Trace.trace(TRACE_MASKD, ": Unknown refcode.");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), HardwareFailuresClass04.XP33_0D_UNKNOWN_REFCODE).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.getProblem().setRefcode(rule.getRefCode());
        if (rule.getExtension().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL extension");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 2, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.getProblem().setExtension(rule.getExtension());
        if (rule.getPriority().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL panel_priority.");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), 5).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.incident.setPriority(rule.getPriorityAsFloat());
        if (rule.getService().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL service");
            new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis0D"), 7).log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        this.getProblem().setService(rule.getService());
        if (rule.getTransmit().equals("")) {
            Trace.trace(TRACE_MASKD, ": ADEPT returned NULL transmit.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 8, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, "<-- analyze()");
            return;
        }
        if (rule.getTransmit().equals("Y")) {
            this.getProblem().setTransmit(true);
        } else {
            this.getProblem().setTransmit(false);
        }
        if (rule.getMessages() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 4, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, " <-- analyze()");
            return;
        }
        ArrayList messages = rule.getMessageList();
        Trace.trace(TRACE_MASKT, "all of our messages ");
        for (int i = 0; i < messages.size(); ++i) {
            Trace.trace(TRACE_MASKT, "index=" + i + " value =" + messages.get(i));
        }
        HardwareAnalysisClass0D.setMessages(this.getProblem(), messages);
        if (this.getProblem().getRefcode().equals("B0000008")) {
            Trace.trace(TRACE_MASKT, ": -> Starting B0000008 RC data leg");
            NetworkSettings networkSettings = NetworkSettings.getNetworkSettings();
            List NIIList = networkSettings.getNetworkInterfaceInfo();
            ListIterator li = NIIList.listIterator();
            while (li.hasNext()) {
                if (((NetworkInterfaceInformation)li.next()).getAdapterType() != 1) continue;
                this.getProblem().setRefcode("B00000E8");
            }
        }
        if (this.getProblem().getRefcode().indexOf("B10D") != -1) {
            this.getProblem().setCategory(2);
            this.getProblem().setDescription(1642);
        } else {
            this.getProblem().setCategory(1);
            this.getProblem().setDescription(1637);
        }
        this.finishAndReport(ourEvent, this.getProblem(), this.incident);
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }
}

